/*
 *
 * \file: mspin_demo_types.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2014 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_DEMO_TYPES_H_
#define MSPIN_DEMO_TYPES_H_

#include <mspin_appl_if_adapter.h>
#include <pthread.h>   // pthread_mutex_t

#include <mutex>
#include <condition_variable>
#include <chrono>
#include <semaphore.h>

#define MSPIN_DEMO_APPL_SCREEN_WIDTH            1024
#define MSPIN_DEMO_APPL_SCREEN_HEIGHT           768

#define MSPIN_DEMO_APPL_MYSPIN1_LAYER_ID        4000
#define MSPIN_DEMO_APPL_MYSPIN1_SURFACE_ID      10
#define MSPIN_DEMO_APPL_MYSPIN1_WIDTH           768
#define MSPIN_DEMO_APPL_MYSPIN1_HEIGHT          480

#define MSPIN_DEMO_APPL_MYSPIN2_LAYER_ID        4001
#define MSPIN_DEMO_APPL_MYSPIN2_SURFACE_ID      11
#define MSPIN_DEMO_APPL_MYSPIN2_WIDTH           480
#define MSPIN_DEMO_APPL_MYSPIN2_HEIGHT          288

#define MSPIN_DEMO_APPL_TOUCH_LAYER_ID          4002
#define MSPIN_DEMO_APPL_TOUCH_SURFACE_ID        12
#define MSPIN_DEMO_APPL_TOUCH_AREA1_WIDTH       MSPIN_DEMO_APPL_SCREEN_WIDTH
#define MSPIN_DEMO_APPL_TOUCH_AREA1_HEIGHT      MSPIN_DEMO_APPL_SCREEN_HEIGHT

#define MSPIN_DEMO_APPL_MYSPIN_FRAME_COMP       MSPIN_FRAME_COMPRESSION_ZLIB

#define MYSPIN_DEMO_APPL_APPLE_VENDOR_ID        0x05ac
#define MYSPIN_DEMO_APPL_APPLE_PRODUCT_ID_MIN   0x1200
#define MYSPIN_DEMO_APPL_APPLE_PRODUCT_ID_MAX   0x12FF

#define MSPIN_DEMO_APPL_GOOGLE_VENDOR_ID        0x18d1
#define MSPIN_DEMO_APPL_GOOGLE_PRODUCT_ID_MIN   0x2d00
#define MSPIN_DEMO_APPL_GOOGLE_PRODUCT_ID_MAX   0x2d05

#define MYSPIN_DEMO_APPL_AUDIO_SOURCE_DEFAULT_APPLE_DEVICE   "plughw:UAC2Gadget,0"
#define MYSPIN_DEMO_APPL_AUDIO_SINK_DEFAULT     "entertainment_main"

#define MSPIN_STR_OTG_PORT                      "1-1"

//#define MYSPIN_DEMO_APPL_SEND_TEST_POSITION     1

//The following defines are only required to disable lines marked with errors in CodeBench
#ifndef TRUE
 #define TRUE   1
#endif

#ifndef FALSE
 #define FALSE  0
#endif

typedef enum
{
    eMSPIN_DEMO_STATE_STOPPED = 0,
    eMSPIN_DEMO_STATE_RUNNING = 1,
} mspin_demo_run_state_t;

typedef enum
{
    eMSPIN_DEMO_STATE_STABLE = 0,
    eMSPIN_DEMO_STATE_SWITCH_TO_RUN = 1,
    eMSPIN_DEMO_STATE_SWITCH_TO_STOP = 2,
    eMSPIN_DEMO_STATE_SWITCH_TO_EXIT = 3,
} mspin_demo_switch_run_state_t;

typedef enum
{
    eMSPIN_RETURN_STATE_SUCCESSFUL_CONNECTION = 0,
    eMSPIN_RETURN_STATE_NO_DEVICE,
    eMSPIN_RETURN_STATE_PHONE_APPEARED
} mspin_demo_return_state_t;

struct usb_device {
    uint32_t vendorId;
    uint32_t productId;
    uint32_t devNum;
    std::string serial;
    std::string devPath;
};

typedef struct
{
    // Shared variable with mspin_demo_monitor
    bool gQuit;
    bool g_connected_device;
    bool g_disconnected_device;

    std::condition_variable g_wifi_monitor_cv;
    std::mutex g_wifi_monitor_m;
    sem_t gConnectSemaphore;

} mspin_demo_monitor_context_t;

typedef struct
{
    uint32_t vendorId;
    uint32_t productId;
    std::string serial;
    uint32_t devNum;
    U32 audioSupport;
    mspin_demo_run_state_t runState;
    mspin_demo_switch_run_state_t switchRunState;
    pthread_mutex_t switchStateMutex;
    bool boardTypeSD;
    MSPIN_Instance_t *pMyspin;
    U8 iOSAppIdentifier;
    U8 sinkEndpoint;
    U8 sourceEndpoint;
    S32 connectionID;
    mspin_demo_monitor_context_t *pMonitorContext;
} mspin_demo_connectionParameter_t;

typedef struct
{
    pthread_t threadId;
    mspin_demo_connectionParameter_t *pConnection;
} mspin_demo_instanceParameter_t;

#endif /* MSPIN_DEMO_TYPES_H_ */
